;; author: azizzaeny
;; src/zaeny/simple_css/core.clj
(ns zaeny.simple-css.core)

;; (assert (even? (count rules)))
(defn render-maps
  "take vector return a map {:sel nil :rules [] }"
  [[selector rules]]
  {:sel (name selector)
   :rules (partition 2 rules)})

(defn render-attr
  "turn individual rules vector [attr v ] into plain string attr : v;"
  [rules]
  (let [[attr v] rules]
    (str (name attr) ":" v ";")))

(defn render-rule
  "take render-maps output turn rules coll into string {:sel nil :rules str}"
  [style-map]
  (let [rules-text (->> (:rules style-map)
                        (map render-attr)
                        (apply str))]

    ;; transform rules into text
    (-> style-map
        (assoc :rules rules-text))))

(defn render-declaration
  "takes render-rule output make it into string "
  [style-map]
  (let [sel (-> style-map :sel name)
        rules (-> style-map :rules)]
    (str sel "{" rules "};\n")))

(defn merge-declarations
  "higher order implement 1, takes style vector, [selector, rules] turn into string"
  [hiccup-css]
  (-> hiccup-css
      render-maps
      render-rule
      render-declaration))

(defn pr-out-css
  "higher order implement 2, takes style vector [selector, rules] turn into  string declarations"
  [hiccup-css]
  (->> hiccup-css
       (map merge-declarations)
       (apply str)))
