(ns simply.gcp.pubsub.simply
  (:require [simply.gcp.pubsub.core :as p]
            [simply.gcp.pubsub.encoding :as encoding]
            [integrant.core :as ig]
            [simply.cqrs :as cqrs]
            [simply.messaging :as messaging]))


(defn events-topic [] (p/topic cqrs/event-topic encoding/encode-camel-case-json))


(defn sms-topic [] (p/topic messaging/sms-topic encoding/encode-camel-case-json))


(defn whatsapp-topic [] (p/topic messaging/whatsapp-topic encoding/encode-kebab-case-edn))


(defn slack-topic [] (p/topic messaging/slack-topic encoding/encode-camel-case-json))


(defn email-topic [] (p/topic messaging/email-topic encoding/encode-camel-case-json))


(defn zendesk-topic [] (p/topic messaging/zendesk-topic encoding/encode-kebab-case-edn))


(defn leads-topic [] (p/topic messaging/lead-topic encoding/encode-camel-case-json))


(defn companies-topic [] (p/topic messaging/companies-topic encoding/encode-kebab-case-edn))


(defn contracts-topic [] (p/topic messaging/contracts-topic encoding/encode-camel-case-json))


(defn new-contracts-topic [] (p/topic messaging/new-contract-topic encoding/encode-pascal-case-json))


(defn brokers-topic [] (p/topic messaging/brokers-topic encoding/encode-camel-case-json))


(defn letters-topic [] (p/topic messaging/letters-topic encoding/encode-kebab-case-edn))


(defn marketing-topic [] (p/topic messaging/marketing-topic encoding/encode-camel-case-json))


(defmethod ig/init-key :simply.gcp.pubsub.simply/events-topic [_ _]
  (events-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/sms-topic [_ _]
  (sms-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/whatsapp-topic [_ _]
  (whatsapp-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/slack-topic [_ _]
  (slack-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/email-topic [_ _]
  (email-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/zendesk-topic [_ _]
  (zendesk-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/leads-topic [_ _]
  (leads-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/companies-topic [_ _]
  (companies-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/contracts-topic [_ _]
  (contracts-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/new-contracts-topic [_ _]
  (new-contracts-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/brokers-topic [_ _]
  (brokers-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/letters-topic [_ _]
  (letters-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/marketing-topic [_ _]
  (marketing-topic))
