(ns simply.url
  (:require [simply.gcp.url :as gcp-url]
            [simply.deps :as deps]
            [simply.core :as s.core]))


(defn- shortner []
  (gcp-url/url-shortner (deps/get-dep :gcp/api-key)))


(defn try-shorten
  "Tries to shorten the given url. Returns the url if it cannot be shortened and raises a silent error.

  Expected system.edn config

  {:simply.deps/deps
   {:gcp/api-key #dyn/prop [GCP_API_KEY \"\"]
    :gcp/short-link-domain #dyn/prop [SHORT_LINK_DOMAIN \"https://smply.page.link?link=\"]}}

  :gcp/short-link-domain can be left out of the system.edn config and passed in via partner config if needed"
  ([url]
   (try-shorten (deps/get-dep :gcp/short-link-domain) url))
  ([short-link-domain url]
   (s.core/try-shorten (shortner) short-link-domain url)))


(comment

  (with-redefs
    [simply.deps/get-dep (fn [k]
                           (get {:gcp/api-key ""
                                 :gcp/short-link-domain "https://smply.page.link?link="}
                                k))]
    (try-shorten "https://simply.co.za")))
