(ns simply.astronomix.astro
  (:require [clojure.java.io :as io]))

(def *initial-config
  (atom
   {:version "0.1.34"
    :js-folder "resources/public/js/"
    :components '[AutoCompleteAddress
                  Avatar
                  Block
                  Button
                  Buttons
                  CenteredLogo
                  Checkbox
                  Checkboxes
                  Col
                  DangerButton
                  DefaultFooter
                  DefaultHeader
                  Field
                  FieldContainer
                  FilledButton
                  Footer
                  Form
                  FormFieldButtons
                  GhostButton
                  GhostSecondaryButton
                  GhostTertiaryButton
                  Header
                  Heading
                  Hint
                  InputButton
                  InputFile
                  InputSelect
                  InputText
                  Minheight
                  Modal
                  PageButtons
                  PrimaryButton
                  Radio
                  Radios
                  Row
                  SecondaryButton
                  SegmentedButton
                  Select
                  SiteProgress
                  Slider
                  SmallDangerButton
                  SmallFilledButton
                  SmallGhostButton
                  SmallGhostSecondaryButton
                  SmallGhostTertiaryButton
                  SmallNeutralButton
                  SmallPrimaryButton
                  SmallSecondaryButton
                  SmallTertiaryButton
                  Spinner
                  Switch
                  Table
                  TertiaryButton
                  TextArea
                  Theme
                  Wrapper]
    :props '[]
    :funcs '[]}))

;; Why is the code below commented out and not deleted?
;; I think there may be a chance we add back the functionality
;; to configure these components from a config file.
;; The commented out code documents how it was done
;; and also why the atom above is called *initial-config

;; If this code is still here a long while after the 25th of August 2021
;; then get rid of it.

#_(defn read-config []
  (let [file-root (io/file "astro.edn")
        file-res (io/file (io/resource "astro.edn"))]
    (cond
      (.exists file-root) (do (prn "Found astro.edn in project root")
                              file-root)
      (.exists file-res) (do (prn "Found astro.edn in resources dir")
                           file-res)
      :else false)))


#_(let [user-config-file (read-config)]
  (if user-config-file
    (let [user-config (-> user-config-file slurp read-string)]
      (swap! *initial-config merge user-config))
    (prn "No astro.edn found, using default config"))
  (def components (:components @*initial-config))
  (def props (:props @*initial-config))
  (def funcs (:funcs @*initial-config)))

(def components (:components @*initial-config))
(def props (:props @*initial-config))
(def funcs (:funcs @*initial-config))
