(ns simply.astronomix.astro
  (:require [clojure.java.io :as io]))

(def *initial-config
  (atom
   {:version "0.1.34"
    :js-folder "resources/public/js/"
    :components '[Avatar
                  Button
                  Checkbox
                  InputSearch
                  InputText
                  Radio
                  Switch
                  TextArea
                  Select
                  Footer
                  Header
                  Sidebar
                  Slider]
    :props '[]
    :funcs '[]}))


(defn read-config []
  (let [file-root (io/file "astro.edn")
        file-res (io/file (io/resource "astro.edn"))]
    (cond
      (.exists file-root) (do (prn "Found astro.edn in project root")
                              file-root)
      (.exists file-res) (do (prn "Found astro.edn in resources dir")
                           file-res)
      :else false)))


(let [user-config-file (read-config)]
  (if user-config-file
    (let [user-config (-> user-config-file slurp read-string)]
      (swap! *initial-config merge user-config))
    (prn "No astro.edn found, using default config"))
  (def components (:components @*initial-config))
  (def props (:props @*initial-config))
  (def funcs (:funcs @*initial-config)))
