(ns simply.errors
  (:require #?(:clj [clojure.spec.alpha :as s])
            #?(:clj [expound.alpha :as expound])
            #?(:clj [slingshot.slingshot :as slingshot])))

(defn error
  ([type message] (error type message {}))
  ([type message data]
   {:type type :message message :data data}))

;;;; app errors

(defn app-error
  ([message] (error :error/app message))
  ([message data] (error :error/app message data)))


#?(:clj (defn throw-app-error
          ([message] (throw-app-error message {}))
          ([message data]
           (slingshot/throw+ (app-error message data)))))


;;;; not found

(defn not-found-error
  ([] (not-found-error "Couldn't find what you are looking for."))
  ([message] (not-found-error message {}))
  ([message data] (error :error/not-found message data)))


#?(:clj (defn throw-not-found-error
          ([] (slingshot/throw+ (not-found-error)))
          ([message] (slingshot/throw+ (not-found-error message)))
          ([message data] (slingshot/throw+ (not-found-error message data)))))

;;;; validation errors

(defn validation-error [errors]
  (error :error/validation "Validation Failed" (if (string? errors) [errors] errors)))


(defn combine-validation-results [validation-results]
  {:valid? (every? :valid? validation-results)
   :errors (reduce
            (fn [errors validation-result]
              (concat errors (:errors validation-result)))
            []
            validation-results)})


(defn validation
  ([] {:valid? true})
  ([& errors] {:valid? false :errors errors}))


#?(:clj (defn throw-if-invalid [{:keys [errors valid?] :as validation}]
          (when-not valid?
            (slingshot/throw+ (validation-error errors)))))


#?(:clj (defn spec-validation [spec x]
          (if (s/valid? spec x)
            (validation)
            (validation (expound/expound-str spec x)))))


#?(:clj (defn throw-if-spec-invalid [spec x]
          (throw-if-invalid (spec-validation spec x))))
