(ns simply.core
  (:require #?(:clj  [clj-time.format :as time.format])
            #?(:clj  [clj-time.core :as time])
            [clojure.string :as string]))

(defprotocol ShortenUrl
  (try-shorten [this url] [this short-domain url]
    "Will use simply short domain if short-domain is not provided"))


(defn now-formatted []
  (time.format/unparse (:date-time time.format/formatters) (time/now)))


(defn capitalize-words
  "Capitalize every word in a string"
  [s]
  (->> (string/split (str s) #"\b")
       (map string/capitalize)
       string/join))



(defn keys-in
  "Get all nested Key paths in a map
   see https://stackoverflow.com/questions/21768802/how-can-i-get-the-nested-keys-of-a-map-in-clojure"
  [m]
  (if (map? m)
    (vec
     (mapcat (fn [[k v]]
               (let [sub (keys-in v)
                     nested (map #(into [k] %) (filter (comp not empty?) sub))]
                 (if (seq nested)
                   nested
                   [[k]])))
             m))
    []))


(defn keyword->ns-str [k]
  (as-> [(namespace k) (name k)] x
    (remove nil? x)
    (clojure.string/join "/" x)))
