(ns simply.ops
  (:require [shutdown.core :as shutdown]
            [simply.cqrs :as cqrs]
            [simply.messaging :as messaging]
            [integrant.core :as ig]))


;; TO USE ADD THE FOLLOWING TO YOUR system.edn file as well as a add the slack topic

;:simply.ops/system-notifications
;{:version #dyn/prop [CI_VERSION "development"]
; :project-id #dyn/prop [GCP_PROJECT_ID "dogmatix"]
; :cqrs-system #ig/ref :suffix/cqrs-system-provider
; :slack-token "your token here"}

(def slack-room "system-ops")


(defn notify-startup [slack-token project-id version cqrs-system]
  (let [message (str "STARTING: *" version "* on *" project-id "*")
        slack (messaging/slack slack-token slack-room "system-startup" message)]
    (cqrs/send-messages cqrs-system messaging/slack-topic [slack])))


(defn notify-shutdown [slack-token project-id version cqrs-system]
  (let [message (str "HALT: *" version "* on *" project-id "*")
        slack (messaging/slack slack-token slack-room "system-shutdown" message)]
    (cqrs/send-messages cqrs-system messaging/slack-topic [slack])))


(defmethod ig/init-key :simply.ops/system-notifications [_ {:keys [slack-token cqrs-system project-id version]}]
  (let [shutdown #(notify-shutdown slack-token project-id version cqrs-system)]
    (notify-startup slack-token project-id version cqrs-system)
    (shutdown/add-hook! ::ops-notifications shutdown)))


(defmethod ig/halt-key! :simply.ops/system-notifications [_ _]
  (shutdown/remove-hook! ::ops-notifications))
