(ns simply.job-requests.pubsub
  (:require [simply.job-requests.core :as job-requests]
            [simply.gcp.pubsub.core :as p]
            [simply.gcp.pubsub.encoding :as encoding]
            [integrant.core :as ig]
            [simply.gcp.pubsub.cqrs :as p.cqrs]
            [clojure.string :as string]))


(defn job-request-topic []
  (p/topic job-requests/job-request-topic-key
           encoding/encode-camel-case-json))


(defmethod ig/init-key :simply.job-requests.pubsub/job-request-topic [_ _]
  (job-request-topic))


(defn job-request-subscription [service-name]
  (let [pull-frequency-in-ms 2500
        failure-ack-deadline-in-s 600
        sub-key (job-requests/job-request-subscription-key service-name)]
    (->
     (p/subscription sub-key
                     job-requests/job-request-topic-key
                     encoding/decode-camel-case-json
                     p.cqrs/system-handles-topic-subscription
                     pull-frequency-in-ms)
     (p/with-ack-deadline failure-ack-deadline-in-s))))


(defmethod ig/init-key :simply.job-requests.pubsub/job-request-subscription
  [_ {:keys [service]}]
  (job-request-subscription service))


;;;; TESTING

(defn request-job [client job-name service data]
  (let [data (assoc data :jobname job-name :service service)
        pubsub (p/pubsub client [(job-request-topic)] [])]
    (p/init pubsub)
    (prn (str "Requesting " job-name " job for service " service))
    (prn data)
    (p/publish pubsub job-requests/job-request-topic-key [data])
    (prn "Done")))
