(ns simply.job-requests.db
  (:require [integrant.core :as ig]))

(defprotocol JobsDb
  (list-jobs [this])
  (create [this job])
  (delete [this job]))


(defn fake-db [log?]
  (if log?
    (reify JobsDb
      (list-jobs [_]
        (prn "** JOBS ** FETCH"))
      (create [_ j]
        (prn "** JOBS ** CREATE")
        (clojure.pprint/pprint j))
      (delete [_ j]
        (prn "** JOBS ** DELETE")
        (clojure.pprint/pprint j)))
    (reify JobsDb
      (list-jobs [_])
      (create [_ _])
      (delete [_ _]))))


(defmethod ig/init-key :simply.job-requests.db/fake-db [_ {:keys [log?]
                                                           :or {log? false}}]
  (fake-db log?))
