(ns simply.http.client
  (:require [aleph.http :as http]
            [byte-streams :as bs]
            [manifold.deferred :as d]))


(defn- body-as-string [response]
  (if (contains? response :body)
    (update response :body bs/to-string)
    response))


(defn request
  "Takes an HTTP request, as defined by the Ring protocol, with the extensions defined
   by [clj-http](https://github.com/dakrone/clj-http), and returns a deferred representing
   the HTTP response."
  [req]
  (d/chain
    (http/request (assoc req :throw-exceptions? false))
    body-as-string))


(comment

  (request {:method :get :url "https://google.com"})

  ,)
