(ns simply.gcp.keys
  (:require [clojure.java.io :as io]))


(def key-file-names
  {:simply-prod "keyfile-prod.json"
   :simply-pre-prod "keyfile-preprod.json"
   :old-mutual-prod "old-mutual-prod.json"
   :absa-prod "absa-prod.json"
   :rml-prod "rml-prod.json"})


(def key-folder "../keys/")


(defn key-file
  "Returns the keyfile path for a chosen env.
   See `key-file-names` for env to file-name mapping."
  [env]
  (let [file-name (get key-file-names env)
        path (str key-folder file-name)]
    (if (.exists (io/file path))
      path
      file-name)))
