(ns simply.ops
  (:require [shutdown.core :as shutdown]
            [simply.cqrs :as cqrs]
            [simply.messaging :as messaging]
            [integrant.core :as ig]
            [manifold.bus :as m.bus]
            [manifold.stream :as m.stream]
            [simply.persistence.core :as p.db]
            [taoensso.timbre :as logger]))


;; TO USE ADD THE FOLLOWING TO YOUR system.edn file as well as a add the slack topic

;:simply.ops/system-notifications
;{:version #dyn/prop [CI_VERSION "development"]
; :project-id #dyn/prop [GCP_PROJECT_ID "dogmatix"]
; :cqrs-system #ig/ref :suffix/cqrs-system-provider
; :slack-token "your token here"}

(def slack-room "system-ops")


(defn notify-startup [slack-token project-id version cqrs-system]
  (let [message (str "STARTING: *" version "* on *" project-id "*")
        slack (messaging/slack slack-token slack-room "system-startup" message)]
    (cqrs/send-messages cqrs-system messaging/slack-topic [slack])))


(defn notify-shutdown [slack-token project-id version cqrs-system]
  (let [message (str "HALT: *" version "* on *" project-id "*")
        slack (messaging/slack slack-token slack-room "system-shutdown" message)]
    (cqrs/send-messages cqrs-system messaging/slack-topic [slack])))


(defmethod ig/init-key :simply.ops/system-notifications [_ {:keys [slack-token cqrs-system project-id version]}]
  (let [shutdown #(notify-shutdown slack-token project-id version cqrs-system)]
    (notify-startup slack-token project-id version cqrs-system)
    (shutdown/add-hook! ::ops-notifications shutdown)))


(defmethod ig/halt-key! :simply.ops/system-notifications [_ _]
  (shutdown/remove-hook! ::ops-notifications))



;; TO USE ADD :simply.ops/report-instance-metrics {} to system.edn

(defn- report-instance-metric [i]
  (try
    (p.db/upsert
      (p.db/entity
        :db-namespace (p.db/db-namespace "OPS")
        :entity-key "system-metrics"
        :id (str (:time i) "-" (:id i))
        :data i))
    (catch Exception e
      (logger/error (ex-info "Cannot persist instance metric" i e)))))


(defn- start-instance-metric-subscription! []
  (->> (m.bus/subscribe cqrs/instance-reporting-bus cqrs/instance-reporting-topic)
       (m.stream/consume #(report-instance-metric %))))


(defmethod ig/init-key :simply.ops/report-instance-metrics [_ _]
  (start-instance-metric-subscription!))
