(ns simply.ops.tracing-db-reporter
  (:require [integrant.core :as ig]
            [manifold.bus :as m.bus]
            [manifold.stream :as m.stream]
            [simply.persistence.core :as p.db]
            [taoensso.timbre :as logger]
            [simply.ops.tracing :as tracing]))


;; TO USE ADD to system.edn
;; :simply.ops.tracing-db-reporter/report-tracing-metrics-to-datastore
;; {:service "your-service"
;;  :report? #dyn/boolean #dyn/prop [SIMPLY_CORE_TRACING_TO_DATASTORE "true"]
;;  :simply.deps/deps #ig/ref :simply.deps/deps}


(defn- report-tracing-metric [service i]
  (try
    (p.db/upsert
      (p.db/entity
        :db-namespace (p.db/db-namespace "OPS")
        :entity-key "tracing-metrics"
        :id (str (:time i) "-" (:id i))
        :data (assoc i :service service)))
    (catch Exception e
      (logger/error (ex-info "Cannot persist instance metric" i e)))))


(defn- start-reporting-tracing-metrics-to-datastore! [service]
  (->> (m.bus/subscribe tracing/tracing-report-bus tracing/tracing-report-topic)
       (m.stream/consume #(report-tracing-metric service %))))


(defmethod ig/init-key :simply.ops.tracing-db-reporter/report-tracing-metrics-to-datastore [_ {:keys [service report?]}]
  (when report?
    (start-reporting-tracing-metrics-to-datastore! service)))


(comment

  (require '[simply.helpers])


  (def request-id
    (->
      (simply.helpers/with-db :emulator
        (p.db/find-all
          (p.db/query
            :db-namespace (p.db/db-namespace "OPS")
            :entity-key "tracing-metrics"
            :limit 1)))
      first
      ::p.db/data
      :request-id))


  (def data
    (->>
      (concat
        (->>
          (simply.helpers/with-db :pre-prod
            (p.db/find-all
              (p.db/query
                :db-namespace (p.db/db-namespace "OPS")
                :entity-key "tracing-metrics"
                :params {:request-id request-id})))
          (map ::p.db/data))

        (->>
          (simply.helpers/with-db :pre-prod
            (p.db/find-all
              (p.db/query
                :db-namespace (p.db/db-namespace "Events")
                :entity-key "event"
                :params {:requestId request-id})))
          (map #(-> % ::p.db/data
                    (assoc :trigger "EVENT"
                           :time (.getTime (.parse (java.text.SimpleDateFormat. "yyyy-MM-dd'T'HH:mm:ss.SSS"  ) (get-in % [::p.db/data :date]))))))))))


  (let [children-by-parent (group-by :parent-id data)
        tree (loop [nodes (get children-by-parent nil [])]
               (prn nodes)
               (if (empty? nodes)
                 nodes
                 (->> nodes
                      (map (fn [n]
                             (-> (assoc n :children (get children-by-parent (:id n) []))
                                 (update n :children #(recur %)))))
                      doall)))]
    tree)


  )
