(ns simply.ops.tracing-db-reporter
  (:require [integrant.core :as ig]
            [manifold.bus :as m.bus]
            [manifold.stream :as m.stream]
            [simply.persistence.core :as p.db]
            [taoensso.timbre :as logger]
            [simply.ops.tracing :as tracing]))


;; TO USE ADD to system.edn
;; :simply.ops.tracing-db-reporter/report-tracing-metrics-to-datastore
;; {:service "your-service"
;;  :report? #dyn/boolean #dyn/prop [SIMPLY_CORE_TRACING_TO_DATASTORE "true"]
;;  :simply.deps/deps #ig/ref :simply.deps/deps}


(defn- report-tracing-metric [service i]
  (try
    (p.db/upsert
      (p.db/entity
        :db-namespace (p.db/db-namespace "OPS")
        :entity-key "tracing-metrics"
        :id (str (:time i) "-" (:id i))
        :data (assoc i :service service)))
    (catch Exception e
      (logger/error (ex-info "Cannot persist instance metric" i e)))))


(defn- start-reporting-tracing-metrics-to-datastore! [service]
  (->> (m.bus/subscribe tracing/tracing-report-bus tracing/tracing-report-topic)
       (m.stream/consume #(report-tracing-metric service %))))


(defmethod ig/init-key :simply.ops.tracing-db-reporter/report-tracing-metrics-to-datastore [_ {:keys [service report?]}]
  (when report?
    (start-reporting-tracing-metrics-to-datastore! service)))
