(ns simply.gcp.util
  (:require [clj-time.coerce :as time.coerce]
            [clj-time.format :as time.format]
            [clojure.string :as string]))


(defn unparse-zulu-date-format [date]
  (str
   (time.format/unparse
    (:date-hour-minute-second-ms time.format/formatters)
    (time.coerce/to-date-time date))
   "000000Z"))


(defn parse-zulu-date-format [date-str]
  (time.coerce/to-date
   (time.format/parse
    (:date-hour-minute-second-ms time.format/formatters)
    (string/replace date-str #"000000Z$" ""))))
