(ns simply.astronomix.rum
  (:refer-clojure :exclude [list])
  (:require [simply.astronomix.core :as astro]
            [goog.object :refer [getValueByKeys]]
            [rum.core])
  (:require-macros [simply.astronomix.macros
                    :refer [export-funcs export-props export-rum-components]]))


;; adapted from https://github.com/tonsky/rum/issues/20
(defn adapt-class [react-class & args]
  (let [[opts children] (if (map? (first args))
                          [(first args) (rest args)]
                          [{} args])
        type# (first children)
        ;; we have to make sure to check if the children is sequential
        ;; as a list can be returned, eg: from a (for)
        new-children (if (sequential? type#)
                       [(sablono.interpreter/interpret children)]
                       children)
        ;; convert any options key value to a react element, if
        ;; a valid html element tag is used, using sablono
        vector->react-elems (fn [[key val]]
                              (if (sequential? val)
                                [key (sablono.interpreter/interpret val)]
                                [key val]))
        new-options (into {} (map vector->react-elems opts))]
    (apply js/React.createElement react-class
      ;; sablono html-to-dom-attrs does not work for nested hashmaps
      (clj->js (astro/map-keys->camel-case new-options :html-props true))
      new-children)))


(export-funcs)
(export-props)
(export-rum-components)
