(ns simply.messaging.whatsapp)

(defn substitute-params
  "Takes a template message, and replaces the params with the values from params.
  Example:

  template-message: {:template \"simply-tenandsix-insured-as-owner-detail-request\"
                     :params [:greeting :link :fsp]}

  params: {:greeting \"Hello\" :link \"http://...\" :fsp 123}

  returns: {:template \"simply-tenandsix-insured-as-owner-detail-request\"
            :params [\"Hello\" \"http://...\" 123]}"
  [template-message params]
  (letfn [(substitute [t-params] (vec (map #(get params %) t-params)))]
    (update template-message :params substitute)))
