(ns simply.helpers
  (:require
   [simply.gcp.pubsub.core :as p]
   [simply.gcp.auth :as auth]
   [simply.gcp.keys :as s.keys]))


(def ^:private envs
  {:emulator [:emulator "dogmatix" #(auth/emulator-client) #(p/emulator-client "8321" "dogmatix" (auth/emulator-client))]
   :prod [:simply-prod "simply-prod"]
   :pre-prod [:simply-pre-prod "simply-pre-prod"]
   :om [:old-mutual-prod "old-mutual-prod"]
   :absa [:absa-prod "absa-prod"]})


(defn available-envs []
  (keys envs))


(defn- guard-config [env]
  (when-not (contains? envs env)
    (throw (ex-info "Invalid Env" {:env env
                                   :available-envs (available-envs)}))))


(defn ->project-id [env]
  (guard-config env)
  (get-in envs [env 1]))


(defn ->client [env]
  (guard-config env)
  (auth/reset-credentials!)
  (let [[k _ client] (get envs env)]
    (if client
      (client)
      (auth/keyfile-client (s.keys/key-file k)))))


(defn ->pubsub-client [env]
  (guard-config env)
  (auth/reset-credentials!)
  (let [[k p-id _ pubsub-client] (get envs env)]
    (if pubsub-client
      (pubsub-client)
      (p/production-client p-id (auth/keyfile-client (s.keys/key-file k))))))
