(ns simply.deps
  (:require [integrant.core :as ig]
            [simply.errors :as e]))

(defonce ^:private *dependencies (atom {}))


(defn get-dep
  [k & {:keys [satisfies]}]
  (let [dep (get @*dependencies k)]

    (when (not (some? dep))
      (e/throw-app-error
       "Dependency not defined, ensure integrant is started and the simply.deps/deps key is added to your config and has the :dep key set"
       {:dep k}))

    (when (and satisfies (not (satisfies? satisfies dep)))
      (e/throw-app-error
       "Dependency does not satisfy expected protocol"
       {:dep k
        :expects (str (:on satisfies))}))

    dep))

(defn set-deps! [deps-map]
  (reset! *dependencies deps-map))


(defmethod ig/init-key :simply.deps/deps [_ dependencies]
  (set-deps! dependencies))


(defmethod ig/halt-key! :simply.deps/deps [_ _]
  (set-deps! {}))
