(ns simply.astronomix.astro
  (:require [clojure.java.io :as io]))

(def *initial-config
  (atom
   {:version "0.1.34"
    :js-folder "resources/public/js/"
    :components '[Avatar
                  Button
                  Checkbox
                  InputSearch
                  InputText
                  Radio
                  Switch
                  TextArea
                  Select
                  Footer
                  Header
                  Sidebar
                  Slider]
    :props '[]
    :funcs '[]}))

(let [user-config-file (io/file "astro.edn")]
  (if (.exists user-config-file)
    (do
      (prn "Found astro.edn User Config")
      (let [user-config (-> user-config-file slurp read-string)]
        (swap! *initial-config merge user-config)))
    (prn "No astro.edn found, using default config"))
  (def components (:components @*initial-config))
  (def props (:props @*initial-config))
  (def funcs (:funcs @*initial-config)))
