(ns simply.auth.otp.db
  (:require [simply.persistence.core :as p]))


(defn- entity
  ([id] (entity id {} {}))
  ([id data meta]
   (p/entity :db-namespace (p/db-namespace "Common")
             :entity-key   "otps"
             :id id
             :data data
             :meta (assoc meta :requested-at :timestamp))))


(defn save [otp-entity meta]
  (p/upsert (entity (:id otp-entity) otp-entity meta)))


(defn get-otp [otp-id]
  (::p/data (p/lookup (entity otp-id))))


(defn delete [otp-id]
  (p/delete (entity otp-id)))
