(ns simply.persistence.memdb
  (:require [simply.persistence.db :refer [Db] :as protocol]
            [simply.persistence.core :as p]
            [integrant.core :as ig]))

(defonce ^:private *db (atom {}))

(defn clear [] (reset! *db {}))

(defn value [] @*db)


(defn- entity->ns [entity]
  (conj (::p/db-namespace entity) (::p/entity-key entity)))


(defn- entity->path [entity]
  (-> entity
      entity->ns
      (conj (::p/id entity))))


(defn db []
  (reify
    Db

    (upsert-entity [_ entity]
      (swap! *db assoc-in (entity->path entity) entity)
      nil)

    (lookup-entity [_ entity]
      (let [e (get-in @*db (entity->path entity))]
        (assoc entity ::p/data (::p/data e))))

    (query-entity [_ query]
      (let [params  (::p/params query)
            matches (->> (get-in @*db (entity->ns query))
                         vals
                         (filter
                          (fn [entity]
                            (->> params
                                 (map (fn [[k v]] (= v (get-in entity [::p/data k]))))
                                 (reduce #(and %1 %2) true)))))
            limit (::p/limit query)
            offset (::p/offset query)]
        (cond->> matches
          offset (drop offset)
          limit (take limit))))

    (delete-entity [_ entity]
      (swap! *db update-in (entity->ns entity) dissoc (::p/id entity))
      nil)

    (query-children [_ query]
      (prn "***********************")
      (prn "QUERY CHILDREN NOT IMPLEMENTED FOR MEM DBFD")
      (prn "***********************")
      [])

    (query-gql [_ gql-query]
      (prn "***********************")
      (prn "GQL QUERY NOT IMPLEMENTED FOR MEM DBFD")
      (prn "***********************")
      [])))


(defmethod ig/init-key :simply.persistence.memdb/db [_ _] (db))


#_(comment

  (clear)

  (value)

  (with-redefs [simply.deps/get-dep (constantly (db))]
    (let [entity (p/entity :db-namespace (p/db-namespace "SMe")
                           :entity-key "company"
                           :id "A"
                           :data
                           {:bar 1})
          l-entity (assoc entity ::p/data {})]

      (doseq [[id v] [["A" 1] ["B" 2] ["C" 2] ["D" 1]]]
        (protocol/upsert-entity (simply.deps/get-dep :db)
                                (-> entity
                                    (assoc ::p/id id)
                                    (assoc-in [::p/data :id] id)
                                    (assoc-in [::p/data :v] v))))

      #_(protocol/lookup-entity (simply.deps/get-dep :db) (assoc l-entity ::p/id "B"))

      (protocol/query-entity (simply.deps/get-dep :db) (p/query :db-namespace (p/db-namespace "SMe")
                                                                :entity-key "company"
                                                                :params {:v 1 :bar 1 :id "A"}
                                                                :limit 4))


      #_(protocol/delete-entity (simply.deps/get-dep :db) (assoc l-entity ::p/id "A"))))



  )
