(ns simply.wording-config.templating
  (:require [clojure.walk :as walk]))

(defprotocol TemplateReference
  (path [this])
  (template-params [this params]))


(declare TREF->str)

(deftype TREF [v]
  TemplateReference
  (path [this] v)
  (template-params [this params]
    (get-in params v))
  Object
  (toString [o] (TREF->str o)))


(defn- TREF->str [t] (str "#sw/tmpl " (path t)))


#?(:clj
   (defmethod print-method TREF [o ^java.io.Writer w]
     (.write w (TREF->str o))))

#?(:clj
   (defmethod print-dup TREF [o ^java.io.Writer w]
     (.write w (TREF->str o))))


(defn template-reference [v] (->TREF v))


(defn get-templatable-items [template]
  (let [*items (atom #{})]
    (walk/prewalk
     (fn [node]
       (when (satisfies? TemplateReference node)
         (swap! *items conj (path node)))
       node)
     template)
    @*items))


(defn apply-template [template params]
  (walk/prewalk
   (fn [node]
     (if (satisfies? TemplateReference node)
       (template-params node params)
       node))
   template))
