# Cron Jobs

A simple system that listens on a pubsub queue for job requests using `handle-topic` and dispatches to `handle-job-request` if the service matches the listening service.

# Installing Cron Jobs

In your ``system.edn`` file add the following:

```
 :simply.job-requests.core/register-job-handler
 {:service "your-service-name"}

 :simply.job-requests.pubsub/job-request-topic
 {}

 :simply.job-requests.pubsub/job-request-subscription
 {:service "your-service-name"}


 :simply.gcp.pubsub.cqrs/pubsub-cqrs-system
 {...
  :subscriptions
  [...
   #ig/ref :simply.job-requests.pubsub/job-request-subscription
   ...]
 }

```

# Registering Cron Jobs

To register a cron job simply extend the `simply.job-requests.core/handle-job-request` multimethod

```
(defmethod handle-job-request "my-job-name"
  [data options]
  (prn "*** JOB RECEIVED WITH DATA ***")
  (prn data)
  (prn "*** AND OPTIONS ***")
  (prn (keys options)))

```

* `data` will be any data you send in the body of the job request pubsub message
* `options` is the dependencies of your system including `cqrs-system` that can be used to dispatch commands


# Schedulling

To allow the scheduler to automatically schedule jobs then add the following in your system.edn

```
:simply.job-requests.db/fake-db {:log? false} ; used for dev
:simply.job-requests.cloud-scheduler/db {} ; used for prod

:simply.deps/deps
 {:gcp/project-id #dyn/prop [GCP_PROJECT_ID "dogmatix"]
  :gcp/client #ig/ref :your-app/client-provider
  :app/service-name "your-app"
  :simply.job-requests.core/db #ig/ref :simply.job-requests.cloud-scheduler/db}


; only jobs added below will get scheduled and only if app/run-jobs? = true
:simply.job-requests.schedule/jobs
 {:run-jobs? #dyn/boolean [SIMPLY_CORE_RUN_JOBS "false"]
  :schedule {"job-name" "* * * * *"
             "job-name-2" "* * * * *"}}

```

# Manual Triggering

You can use `simply.job-requests.pubsub/request-job` to manually trigger a job for a service. Client should be a pubsub client.
