(ns simply.job-requests.core
  (:require [simply.cqrs :as cqrs]
            [integrant.core :as ig]))

(def job-request-topic-key "simply-cron-jobs")


(defmulti handle-job-request (fn [data options] (:jobname data)))


(defn job-request-subscription-key [service-name]
  (str service-name "-" job-request-topic-key "-sub"))


(defn subscribe-to-cron-job-requests!
  "Creates a topic subscription that listens for job requests targeted at this service and calls handle-job-request if the service matches"
  [service-name]
  (let [sub-key (job-request-subscription-key service-name)]
    (defmethod cqrs/handle-topic
      [job-request-topic-key sub-key]
      [_ _ data options]
      (let [{:keys [service]} data]
        (when (= service service-name)
          (handle-job-request data options))))))


(defmethod ig/init-key :simply.job-requests.core/register-job-handler
  [_ {:keys [service]}]
  (subscribe-to-cron-job-requests! service))


;;;; TESTING

(defmethod handle-job-request "test-job-request-queue"
  [data options]
  (prn "*** JOB RECEIVED WITH DATA ***")
  (prn data)
  (prn "*** AND OPTIONS ***")
  (prn (keys options)))
