(ns simply.gcp.pubsub.encoding
  (:require [base64-clj.core :as base64]
            [camel-snake-kebab.core :as camel-snake]
            [cheshire.core :as json]
            [clojure.edn :as edn]
            [clojure.string :as string]))


(defn- json-value-fn [k v]
  (cond
    (uuid? v) (str v)
    (keyword? v) (name v)
    :else v))


(defn- replace-? [v] (string/replace v "?" ""))


(defn- re-add-? [k]
  (if (string/starts-with? k "is-")
    (str (subs k 3) "?")
    k))


(defn ->camel-key [k] (-> k name camel-snake/->camelCase replace-?))


(defn ->pascal-key [k] (-> k name camel-snake/->PascalCase replace-?))


(defn ->upcase-key [k] (-> k camel-snake/->SCREAMING_SNAKE_CASE_STRING))


(defn ->edn-key [k] (-> k camel-snake/->kebab-case-string re-add-? keyword))


(defn- decode-to-edn-case [data] (-> data base64/decode (json/parse-string ->edn-key)))


;;;; PASCAL
(defn encode-pascal-case-json [data]
  (-> data
      (json/generate-string {:key-fn ->pascal-key :value-fn json-value-fn})
      base64/encode))


(defn decode-pascal-case-json [data] (decode-to-edn-case data))


;;;; CAMEL

(defn encode-camel-case-json [data]
  (-> data
      (json/generate-string {:key-fn ->camel-key :value-fn json-value-fn})
      base64/encode
      ))


(defn decode-camel-case-json [data] (decode-to-edn-case data))


;;;; KABAB

(defn encode-kebab-case-edn [data]
  (-> data pr-str base64/encode))


(defn decode-kebab-case-edn [data]
  (-> data base64/decode edn/read-string))


;;;; STRING

(defn encode-string [data]
  (base64/encode data))


(defn decode-string [data]
  (base64/decode data))
