(ns simply.ops.tracing-log-reporter
  (:require [integrant.core :as ig]
            [manifold.bus :as m.bus]
            [manifold.stream :as m.stream]
            [taoensso.timbre :as logger]
            [simply.gcp.logging :as logging]
            [simply.ops.tracing :as tracing]
            [simply.gcp.util :as util]))


;; TO USE ADD to system.edn
;; :simply.ops.tracing-log-reporter/report-tracing-metrics-to-logger
;; {:service "your-service"
;;  :partner #dyn/prop [PARTNER "simply"]
;;  :client #ig/ref :your-client-provider-goes-here
;;  :report? #dyn/boolean #dyn/prop [SIMPLY_CORE_TRACING_TO_LOGGER "false"]}


(defn- report-tracing-metric [client context partner service i]
  (try
    @(client
       (logging/write-log-request
         {:entries [(assoc context
                           :severity (:info logging/level-mapping)
                           :jsonPayload {:trace-metric (assoc i
                                                              :partner partner
                                                              :service service
                                                              :log-type "TRACING_METRIC")})]}))
    (catch Exception e
      (logger/error (ex-info "Cannot log tracing metric" i e)))))


(defn- start-reporting-tracing-metrics-to-logger! [client context partner service]
  (->> (m.bus/subscribe tracing/tracing-report-bus tracing/tracing-report-topic)
       (m.stream/consume #(report-tracing-metric client context partner service %))))


(defmethod ig/init-key :simply.ops.tracing-log-reporter/report-tracing-metrics-to-logger
  [_ {:keys [client partner service report?]}]
  (when report?
    (let [context (logging/get-entry-metadata)]
      (start-reporting-tracing-metrics-to-logger!
        (logging/wrap-client client) context partner service))))


(comment
  (require '[simply.helpers])

  (report-tracing-metric
    (logging/wrap-client (simply.helpers/->client :pre-prod))
    logging/test-meta "simoly" "10n6" {:time 1 :id (java.util.UUID/randomUUID)})

  )
