(ns simply.server
  (:require [integrant.core :as ig]
            [ring.adapter.jetty :as jetty]))


;;;; JETTY

(defmethod ig/init-key :simply.server/jetty [_ opts]
  (let [handler (atom (delay (:handler opts)))
        options (-> opts (dissoc :handler) (assoc :join? false))]
    {:handler handler
     :server  (jetty/run-jetty (fn [req] (@@handler req)) options)}))


(defmethod ig/halt-key! :simply.server/jetty [_ {:keys [server]}]
  (.stop server))


(defmethod ig/suspend-key! :simply.server/jetty [_ {:keys [handler]}]
  (reset! handler (promise)))


(defmethod ig/resume-key :simply.server/jetty [key opts old-opts old-impl]
  (if (= (dissoc opts :handler) (dissoc old-opts :handler))
    (do (deliver @(:handler old-impl) (:handler opts))
        old-impl)
    (do (ig/halt-key! key old-impl)
        (ig/init-key key opts))))
