(ns simply.logging.test
  (:require [taoensso.timbre :as log]
            [clojure.test :as t]))


(defn test-timbre-logger []
  (let [*logged-data (atom {})]
    {:logged-data *logged-data
     :key (.toString (java.util.UUID/randomUUID))
     :appender
     {:enabled? true
      :async? false
      :min-level nil
      :output-fn :inherit
      :fn
      (fn [{:keys [level vargs]}]
        (reset! *logged-data
                (update @*logged-data
                        level
                        #(conj % vargs))))}}))


(defn add-test-timbre-logger [test-timbre-logger]
  (log/merge-config! {:appenders {(:key test-timbre-logger)
                                  (:appender test-timbre-logger)}}))


(defn reset-test-timbre-logger [test-timbre-logger]
  (reset! (:logged-data test-timbre-logger) {})
  nil)


(defn remove-test-timbre-logger [test-timbre-logger]
  (log/merge-config! {:appenders {(:key test-timbre-logger)
                                  nil}}))

(defn assert-has-logged
  [{:keys [logged-data] :as test-timbre-logger} level expected-vargs-coll]
  (let [actual-data (-> @logged-data
                        (get level)
                        reverse)]
    ;(reset-test-timbre-logger test-timbre-logger)
    (t/is (= expected-vargs-coll actual-data) (str "Expected to have logged at level " level))))


(defn assert-has-not-logged
  [{:keys [logged-data] :as test-timbre-logger}]
  (t/is (= {} @logged-data) "Expected to not have logged"))

(comment
  ;;; Example
  (let [foo (test-timbre-logger)]
    (add-test-timbre-logger foo)
    (assert-has-logged foo :debug [["bar"] ["bar2"]])
    (remove-test-appender foo))
  )
