# ASTRONOMIX

This readme details how to use [Astronomix](https://gitlab.com/SimplyFinServices/astronomix) with your rum/reagent websites.

The code used in this implementation was basically copied from [https://github.com/priornix/antizer](https://github.com/priornix/antizer) and assumes you are using the latest react and reagent libs (as of March 2019).

# HOW DOES IT WORK

simply.astronomix provides a simple wrapper around the javascript astronomix implementation to make it easy to consume astronomix react components in a native rum/reagent way. It does not depend on a specific astro version and allows the consumer to spesify and update this version as they see fit, independent of the simply.core version that is deployed.

# INSTALLING

**1. Getting astro**

You need to include astronomix in your project. The `simply.astronomix.assets` namespace provides a `download` function that will pull all the assets you need.

Add the following code to your user.clj file and run the `update-astro` function with the version you want.

```
;; (:require [simply.astronomix.assets :as astro-assets])

(defn update-astro [version]
  (let [asset-path "resources/public/astro/"
        js-path "resources/public/astro/js"]
    (astro-assets/download version asset-path js-path)))

(comment
  (update-astro "0.3.8")
  )

```


**2. Adding Astro Javascript**

You need to load your code in the correct order:

1. React
2. Astronomix Components (from step 1)
3. Your code using astronomix

It is suggested that you use the [:foreign-libs](https://cljs.github.io/api/compiler-options/foreign-libs) clojurescript compiler option to load astro in the correct order:

```

:foreign-libs [{:file "resources/public/astro/js/astronomix.js"
                :file-min "resources/public/astro/js/astronomix.min.js"
                :provides ["your-app.astro"]
                :requires ["cljsjs.react"]}]
```

Add the above to all the relevant clojurescript compiler options.

Then at the top of your app's core namespace add `(:require [your-app.astro])`;

**3. astro.edn**

In the root of your project include a `astro.edn` file containing the following content. Note this config is tied to version 0.3.8 and you might need to alter it based on the version you are installing (see Upgrading Astronomix Locally below).

```
{:components
 [Avatar
  Button
  Checkbox
  InputSearch
  InputText
  Radio
  Switch
  TextArea
  Select
  Footer
  Header
  Sidebar
  Slider]
 :props []
 :funcs []}
```

**4. Adding Astro Assets**

Wrap your ring handler function to include the astro resources.

```
;; (:require [ring.middleware.resource :as ring.resource]])

(-> your-handler
    (ring.resource/wrap-resource "public/astro"))
```

**5. Adding Astro CSS**

Find the minified css file in `resources/public/astro` and add it to your index.html

```
<link href="/main.e9fe827c.css" rel="stylesheet" type="text/css">

```

**6. Commit Files To Source**

git all the changes from 1-6


# USAGE

For Reagent:

```clojure
(ns foo
 (:require [simply.astronomix.reagent :as a]
           [reagent.core :as r]))

(defn click-me []
  [a/button {:on-click #(prn "works")} "Click me"])

(defn init! []
  (r/render [click-me] (.-body js/document)))
```

For Rum:

```clojure
(ns foo
 (:require [simply.astronomix.rum :as a]
           [rum.core :as rum]))

(defn click-me []
  (a/button {:on-click #(prn "Hello Rum!")} "Click me"))

(defn init! []
  (rum/mount (click-me) (.-body js/document)))
```

# UPGRADING ASTRONOMIX LOCALLY

1. Run the `update-astro` from step 1 in the INSTALLING section with the version you want.
2. Repeat step 5 from the INSTALLING section to ensure you have the correct css.
2. Add any new components/props/functions that you want to use, in your `astro.edn` file. The correct names can be found [here](https://gitlab.com/SimplyFinServices/astronomix/blob/master/src/index.js).

# UPDATE ASTRONOMIX IN SIMPLY CORE

Astronomix deploys a umd build containing everything needed to include the components and styling on a website.

The builds can be found under [https://unpkg.com/@simply-fin-services/astronomix@0.1.34/umd/](https://unpkg.com/@simply-fin-services/astronomix@0.1.34/umd/). Be sure to check for the **latest** version.

* Update `astro.clj` with any new components and functions and props found [here](https://gitlab.com/SimplyFinServices/astronomix/blob/master/src/index.js).
* Deploy simply.core as per deploy.md

# IF YOU NEED EXTERNS

1. Browse to https://jmmk.github.io/javascript-externs-generator/
2. Load [https://unpkg.com/@simply-fin-services/astronomix@0.1.34/umd/@simply-fin-services/astronomix.min.js](https://unpkg.com/@simply-fin-services/astronomix@0.1.34/umd/@simply-fin-services/astronomix.min.js) making sure you have **your** version
3. Enter `Astronomix` under `Enter the JavaScript object you want to extern:` and hit the `Extern!` button
4. Copy the generated code to your project
5. Include it in the compiler :externs configuration