(ns simply.http.client
  (:require [aleph.http :as http]
            [byte-streams :as bs]
            [manifold.deferred :as d]))


(defn- body-as-string [response]
  (if (contains? response :body)
    (update response :body bs/to-string)
    response))


(defn request
  "Takes an HTTP request, as defined by the Ring protocol, with the extensions defined
   by [clj-http](https://github.com/dakrone/clj-http), and returns a deferred representing
   the HTTP response."
  [{:keys [response-body-as-string?]
    :or {response-body-as-string? true}
    :as request-config}]
  (let [request (http/request (assoc request-config :throw-exceptions? false))]
    (if (true? response-body-as-string?)
      (d/chain request body-as-string)
      request)))
