(ns simply.core
  (:require #?(:clj  [clj-time.format :as time.format])
            #?(:clj  [clj-time.core :as time])
            [clojure.string :as string]))

(defprotocol ShortenUrl
  (try-shorten [this url]))


(defn now-formatted []
  (time.format/unparse (:date-time time.format/formatters) (time/now)))


(defn capitalize-words
  "Capitalize every word in a string"
  [s]
  (->> (string/split (str s) #"\b")
       (map string/capitalize)
       string/join))
