# Cron Jobs

A simple system that listens on a pubsub queue for job requests using `handle-topic` and dispatches to `handle-job-request` if the service matches the listening service.

# Installing Cron Jobs

In your ``system.edn`` file add the following:

```
 :simply.job-requests.core/register-job-handler
 {:service "your-service-name"}

 :simply.job-requests.pubsub/job-request-topic
 {}

 :simply.job-requests.pubsub/job-request-subscription
 {:service "your-service-name"}


 :simply.gcp.pubsub.cqrs/pubsub-cqrs-system
 {...
  :subscriptions
  [...
   #ig/ref :simply.job-requests.pubsub/job-request-subscription
   ...]
 }

```

# Registering Cron Jobs

To register a cron job simply extend the `simply.job-requests.core/handle-job-request` multimethod

```
(defmethod handle-job-request "my-job-name"
  [data options]
  (prn "*** JOB RECEIVED WITH DATA ***")
  (prn data)
  (prn "*** AND OPTIONS ***")
  (prn (keys options)))

```

* `data` will be any data you send in the body of the job request pubsub message
* `options` is the dependencies of your system including `cqrs-service` that can be used to dispatch commands


# Schedulling

You can schedule cron jobs using app engine cron.yaml (that lives in fulliautomatix). All query params will be passed to your handler in the data map. jobName and service are required fields.

A cron might look as follows

```
- description: my trigger
  url: /jobs/trigger-job?service=suffix-2&jobname=my-job-name&foo=bar
  target: fulliautomatix
  schedule: every day 04:00
  retry_parameters:
    min_backoff_seconds: 30
    job_retry_limit: 1
  timezone: Africa/Johannesburg
```

* service should match the service defined in your system.edn
* jobname should match the jobname from your defmethod implementation

# Manual Triggering

You can use `simply.job-requests.pubsub/request-job` to manually trigger a job for a service. Client should be a pubsub client.


# Installing Meta

This is only needed for initial setup and can be considered as already done

Cron jobs rely on fullyautomatix to run in app engine as well as the cloud function that can be found in the cloud_function folder
