(ns simply.auth.jwt
  (:require
   [buddy.sign.jwt :as jwt]
   [clj-time.core :refer [now plus days minutes] :as time]
   [clj-time.coerce :as time.coerce]))

(defn expires-in-days [n]
  (plus (now) (days n)))


(defn expires-in-minutes [n]
  (plus (now) (minutes n)))


(defn issue-jwt
  "Issues a json web token"
  [secret expiry data]
  (jwt/sign {:data data :exp expiry :iat (now)} secret))


(defn decode-jwt
  "Returns the data of a token, even if the token is expired. Use verify-jwt to check if a token is valid and not expired"
  [token secret]
  (jwt/unsign token secret {:skip-validation true}))


(defn verify-jwt
  "Returns true if a token is valid and not expired"
  [secret token]
  "Returns true if the token is valid"
  (try
    (let [token-data (jwt/unsign token secret)
          exp (get-in token-data [:exp])]
      (time/before? (now) (time.coerce/from-epoch exp)))
    (catch Exception e false)))
