(ns simply.tracking.segment.core)

;;;;;; Rules

(def identify-actions
  #{
    "question-answered"
    })

(def segment-identify-question-id-map
  {
   :contact-firstname :firstName
   :contact-surname :lastName
   :contact-cellphone-number :phone
   :contact-email :email
   :company-name :companyName
   :company-registration-number :companyRegNumber
    })

(def group-answers
  #{
    "company-registration-number"
    "company-name"
    })

;;;;;; Validations

(defn is-identify-question? [data segment-identify-question-id-map]
  (let [question-id (get-in data [:request :question-id])]
    (some? (segment-identify-question-id-map (keyword question-id)))))


(defn is-identify-action? [action identify-actions]
    (some? (identify-actions (name action))))


(defn should-send-identify? [action data]
  (and (is-identify-question? data segment-identify-question-id-map)
       (is-identify-action? action identify-actions)))


(defn ->segment-data [data]
  (let [request (:request data)
        seg-key ((keyword (:question-id request)) segment-identify-question-id-map)]
    (clj->js {seg-key (:answer request)})))


;;;;;; Segment API's



(defn identify [data]
  (when (exists? js/analytics)
    (js/analytics.identify (str (get-in data [:request :interaction-id]))
                           (->segment-data data))))


(defn track [action data]
  (let [action-type (clj->js action)
        json-data (clj->js data)]
    (when (exists? js/analytics)
      (do
        (js/analytics.track action-type json-data)
        (cond-> data
          (should-send-identify? action data)
          (identify))))))


(defn page []
  (when (exists? js/analytics)
    (do
      (js/analytics.page))))

