const PubSub = require('@google-cloud/pubsub');
const topicKey = 'simply-cron-jobs';

const publish = (data, res) => {
  const pubsub = new PubSub();
  const topic = pubsub.topic(topicKey);
  const publisher = topic.publisher();
  const buffer = Buffer.from(JSON.stringify(data));
  publisher.publish(buffer, (err, messageId) => {
    if (err) {
      return res.status(500).send(err);
    }
    return res.send(`Pushed job ${data.jobname} to service ${data.service} with id ${messageId}`);
  });
};

const authenticate = (req) => {
  const h = req.query.requestkey;
  if ("a494b159-ac60-4397-91ff-d738e790f561" != h) {
    throw new Error('can only execute job request from fulli');
  }
}

const validate = (req) => {
  if (!req.query.jobname) {
    throw new Error('jobname Query Param Required');
  }

  if (!req.query.service) {
    throw new Error('service Query Param Required');
  }
}


exports.triggerJob = (req, res) => {
  authenticate(req);
  validate(req);
  return publish(req.query, res);
};
