(ns simply.astronomix.theme
  (:require [goog.object :as o]))


(def default-theme-id "simply")

(defonce ^:private **theme** (atom nil))


(defn set-theme!
  ([] (set-theme! default-theme-id))
  ([theme-id]
   (let [get-theme-config (o/get js/Astronomix "getThemeConfig")
         theme (get-theme-config theme-id)]
     (reset! **theme** (js->clj theme :keywordize-keys true)))))


(defn theme-config []
  (let [theme @**theme**]
    (when (nil? theme)
      (throw (js/Error. "Theme not defined! Call `simply.astronomix.theme/set-theme!`")))
    theme))


;;;; THEME HELPERS

;; GENERAL

(defn padding [] (:padding (theme-config)))
(defn radius [] (:radius (theme-config)))
(defn border-width [] (:border_width (theme-config)))


;; COLOUR

(defn colours [] (:colours (theme-config)))

(defn primary-colours [] (:primary (colours)))
(defn secondary-colours [] (:secondary (colours)))
(defn tertiary-colours [] (:tertiary (colours)))
(defn neutral-colours [] (:neutral (colours)))
(defn danger-colours [] (:danger (colours)))

(defn primary-colour [] (:base (primary-colours)))
(defn secondary-colour [] (:base (secondary-colours)))
(defn tertiary-colour [] (:base (tertiary-colours)))
(defn neutral-colour [] (:base (neutral-colours)))
(defn danger-colour [] (:base (danger-colours)))


;; SPACES

(defn spaces [] (:spaces (theme-config)))

(defn space-super-loose [] (:superLoose (spaces)))
(defn space-extra-loose [] (:extraLoose (spaces)))
(defn space-loose [] (:loose (spaces)))
(defn space-bit-loose [] (:bitLoose (spaces)))
(defn space-base [] (:base (spaces)))
(defn space [] (space-base))
(defn space-tight [] (:tight (spaces)))
(defn space-extra-tight [] (:extraTight (spaces)))
(defn space-cellheight [] (:cellheight (spaces)))


;; BOX SHADDOWS

(defn box-shadows [] (:size (:boxShadow (theme-config))))

(defn box-shadow-100 [] (get (box-shadows) :100))
(defn box-shadow-200 [] (get (box-shadows) :200))
(defn box-shadow-300 [] (get (box-shadows) :300))
(defn box-shadow-400 [] (get (box-shadows) :400))
(defn box-shadow-500 [] (get (box-shadows) :500))
