(ns simply.gcp.pubsub.simply
  (:require [simply.gcp.pubsub.core :as p]
            [simply.gcp.pubsub.encoding :as encoding]
            [integrant.core :as ig]
            [simply.cqrs :as cqrs]
            [simply.messaging :as messaging]))


(defn events-topic [] (p/topic cqrs/event-topic encoding/encode-camel-case-json))


(defn sms-topic [] (p/topic messaging/sms-topic encoding/encode-camel-case-json))


(defn slack-topic [] (p/topic messaging/slack-topic encoding/encode-camel-case-json))


(defn email-topic [] (p/topic messaging/email-topic encoding/encode-camel-case-json))


(defn zendesk-topic [] (p/topic messaging/zendesk-topic encoding/encode-kebab-case-edn))


(defmethod ig/init-key :simply.gcp.pubsub.simply/events-topic [_ _]
  (events-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/sms-topic [_ _]
  (sms-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/slack-topic [_ _]
  (slack-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/email-topic [_ _]
  (email-topic))


(defmethod ig/init-key :simply.gcp.pubsub.simply/zendesk-topic [_ _]
  (zendesk-topic))
