# ASTRONOMIX

This readme details how to use [Astronomix](https://gitlab.com/SimplyFinServices/astronomix) with your react/reagent websites.

The code used in this implementation was basically copied from [https://github.com/priornix/antizer](https://github.com/priornix/antizer) and assumes you are using the latest react and reagent libs (as of 25 October 2018).

# INSTALLING ASTRONOMIX

1. Prep Files
  * Copy the files under `./simply/astronomix/resources` to your project
  * Reference `astronomix.externs.js` in your project.clj file under `{:cljsbuild {:builds [{:compiler {:externs ["path/to/astronomix.externs.js"]}}]}}`. This step is only needed for builds using `:optimizations :advanced` compiling.

2. Add css and js files to index.html. Because of the loading order of js files they need to be included as follows.
```
    <script src="js/astronomix.externs.js" type="text/javascript"></script>
    <script src="/js/compiled/your-cljs.js" type="text/javascript"></script>
    <script src="/js/astronomix0.1.34.min.js" type="text/javascript"></script>
```

3. Make sure your code using astronomix only runs after files have loaded

```
(.addEventListener
   js/window
   "DOMContentLoaded"
   (fn [] (start-your-app)))
```

When using figwheel you might keep track of how your app was loaded as follows

```
(if (:app-loaded (get-state))
  (mount-app)
  (.addEventListener
   js/window
   "DOMContentLoaded"
   (fn [] (mount-app))))
```

# USAGE

For Reagent:
```clojure
(require '[simply.astronomix.reagent :as a])
(require '[reagent.core :as r])

(defn click-me []
  [a/button {:on-click #(prn "works")} "Click me"])

(defn init! []
  (r/render [click-me] (.-body js/document)))
```

For Rum:
```clojure
(require '[simply.astronomix.rum :as a])
(require '[rum.core :as rum])

(defn click-me []
  (a/button {:on-click #(prn "Hello Rum!")} "Click me"))

(defn init! []
  (rum/mount (click-me) (.-body js/document)))
```


# UPDATE ASTRONOMIX

Astronomix deploys a umd build containing everything needed to include the components and styling on a website.

The builds can be found under [https://unpkg.com/@simply-fin-services/astronomix@0.1.34/umd/](https://unpkg.com/@simply-fin-services/astronomix@0.1.34/umd/). Be sure to check for the **latest** version.

* Download the relevant .min.js, .css files and any other resources present.
* Save these under ./simply/astronomix/resources and give make sure the version number is added to the js and css files
* Remove the old resources
* Regenerate the Externs file
  * Browse to https://jmmk.github.io/javascript-externs-generator/
  * Load [https://unpkg.com/@simply-fin-services/astronomix@0.1.34/umd/@simply-fin-services/astronomix.min.js](https://unpkg.com/@simply-fin-services/astronomix@0.1.34/umd/@simply-fin-services/astronomix.min.js) making sure you have the correct version
  * Enter `Astronomix` under `Enter the JavaScript object you want to extern:` and hit the `Extern!` button
  * Copy the generated code into `resources/astronomix.externs.js`
* Update `astro.clj` with any new components and functions
* Repeat `Installing Astronomix` section in your project
