(ns simply.gcp.url
  (:require [clojure.string :as string]
            [clojure.data.json :as json]
            [org.httpkit.client :as client]
            [simply.core :refer [ShortenUrl]]
            [integrant.core :as ig]))


(defn- shorten-request [key long-url]
  {:method :post
   :url (format "https://www.googleapis.com/urlshortener/v1/url?key=%s" key)
   :body (json/write-str {:longUrl long-url})
   :headers {"Content-Type" "application/json"}})


(defn- shorten [key long-url]
  (let [request (shorten-request key long-url)
        response @(client/request request)
        valid? (= 200 (:status response))]
    (if valid?
      (-> response :body (json/read-str :key-fn keyword) :id)
      long-url)))


(defn url-shortner [api-key]
  (reify
    ShortenUrl
    (try-shorten [this long-url]
      (if api-key
        (shorten api-key long-url)
        long-url))))


(defmethod ig/init-key :simply.gcp.url/url-shortner
  [_ {:keys [api-key]}]
  (url-shortner api-key))
