(ns simply-ux.component.core
  (:require [reagent.core :as reagent]
            [simply-ux.component.builder :as component-builder]))


(def ->component component-builder/->component)


(def ->child-component component-builder/->child-component)


(def define-component component-builder/define-component)


(defn scroll-to-top []
  (.scrollTo js/window 0 0))


(defn render-component
  [& {:keys [component element-id]}]
  (let [dom-element         (.getElementById
                             js/document element-id)

        component-to-render (component-builder/->component
                             component)]

    (if (not (nil? dom-element))
      (do
        (scroll-to-top)

        (reagent/render
         component-to-render
         dom-element)))))
