(ns simply-ux.app-wording
  (:require [simply-ux.state-store :as state-store]
            [simply-ux.ui-app :as ui-app])
  (:refer-clojure :exclude [get]))

(defn get [key & [options]]
  (let [state   (state-store/current-state)
        value   (get-in state [:app-wording key])
        wording (if (fn? value)
                  (value options)
                  value)]
    wording))


(defn get-html [key & [options]]
  (ui-app/emebeded-html-content
   (get key options)))
