(ns simply-ux.routing
  (:require [goog.events :as events]
            [goog.history.EventType :as EventType]
            [secretary.core :as secretary]
            [clojure.string :as string])
  (:import goog.History))

(defn normalize-route [path]
  (string/replace path #"^!" ""))

(defn setup []
  (secretary/set-config! :prefix "#")

  (let [h (History.)]
    (goog.events/listen h EventType/NAVIGATE #(secretary/dispatch! (normalize-route (.-token %))))
    (doto h (.setEnabled true))))
