(ns simply-ux.feature-toggle
  (:require [simply-ux.state-store :as state-store]))


(defn- is-enabled? [feature enabled-features]
  (let [feature-filter (if (keyword? feature)
                         #{feature}
                         (set (:or feature)))]
    (not
     (nil?
      (some feature-filter
            enabled-features)))))


(defn feature-enabled? [feature]
  (let [state            (state-store/current-state)
        enabled-features (:enabled-features state)]
    (is-enabled?
     feature
     enabled-features)))


(defn feature [feature component]
  (if (feature-enabled? feature)
    component))
