(ns simply-ux.ui-app
  (:require [reagent.core :as reagent]
            [clojure.string :as string]
            [simply-ux.state-store :as state-store]))


(defn dom-event->value [event]
  (-> event
      .-target
      .-value))


(defn on-press-enter [handler]
  (fn [event]
    (let [key-pressed (string/lower-case (.-key event))]
      (if (= key-pressed "enter")
        (handler)))))


(defn focus-on-element [id]
  (if-let [element (.getElementById js/document id)]
    (.focus element)))


(defn emebeded-html-content [content]
  [:span
   {:dangerouslySetInnerHTML #js{:__html content}}])


(defn scroll-to-top []
  (.scrollTo js/window 0 0))


(defn navigate-to [path]
  (let [single-page-app-url (str "#" path)]
    (set! js/window.location.href
          single-page-app-url)))


(defn navigate-to-web-url [path]
  (set! js/window.location.href
        path))


(defn with-state [render state-scope props]
  (fn []
    (let [state (if (not state-scope)
                  (state-store/current-state)
                  (state-store/scoped-current-state
                   state-scope))]
      (if (not (empty? props))
        (render state props)
        (render state)))))


(defn ->component [component]
  (let [state-scope     (:state-scope component)

        props           (merge {}
                               (:default-props component)
                               (:props component))

        render-function (if (map? component)
                          (with-state (:render component)
                            state-scope props)
                          (with-state component state-scope props))

        life-cyle      (if (map? component)
                         (-> component
                             (dissoc :render)
                             (dissoc :props)
                             (dissoc :default-props))
                         {})]
    [(with-meta
       render-function
       life-cyle)]))


(defn render-component
  [& {:keys [component element-id]}]
  (let [dom-element         (.getElementById
                             js/document element-id)

        component-to-render (->component
                             component)]

    (if (not (nil? dom-element))
      (do
        (scroll-to-top)

        (reagent/render
         component-to-render
         dom-element)))))


(defn run-delayed [{:keys [seconds]} handler]
  (let [seconds->miliseconds (* 1000 seconds) ]
    (js/setTimeout handler
                   seconds->miliseconds)))


(defn this-page []
  (.-hash js/window.location))
