(ns simply-ux.ui-app
  (:require [clojure.string :as string]
            [goog.dom.safe :as safe-dom]
            [simply-ux.component.builder :as component-builder]
            [simply-ux.component.core :as component-core]))


(defn dom-event->value [event]
  (-> event
      .-target
      .-value))


(defn dom-event->checked? [event]
  (-> event
      .-target
      .-checked))


(defn on-press-enter [handler]
  (fn [event]
    (let [key-pressed (string/lower-case (.-key event))]
      (if (= key-pressed "enter")
        (handler)))))


(defn focus-on-element [id]
  (if-let [element (.getElementById js/document id)]
    (.focus element)))


(defn emebeded-html-content [content]
  [:span
   {:dangerouslySetInnerHTML #js{:__html content}}])


(defn scroll-to-top []
  (.scrollTo js/window 0 0))


(defn navigate-to [path]
  (let [single-page-app-url (str "#" path)]
    (set! js/window.location.href
          single-page-app-url)))

;; External link

;; https://google.github.io/closure-library/api/goog.dom.safe.html#setLocationHref

(defn navigate-to-external-url [url]
  (safe-dom/setLocationHref
   js/window.location url))


;; Alias for backwards compatability of navigate-to-web-url function
(def navigate-to-web-url navigate-to-external-url)


(defn run-delayed [{:keys [seconds]} handler]
  (let [seconds->miliseconds (* 1000 seconds) ]
    (js/setTimeout handler
                   seconds->miliseconds)))


(defn this-page []
  (.-hash js/window.location))


(defn with-input-value [event function]
  (let [value (dom-event->value event)]
    (function value)))


;; --- Component ---

(def ->component component-core/->component)


(def ->child-component component-core/->child-component)


(def define-component component-core/define-component)


(def render-component component-core/render-component)
