(ns simply-ux.component.rendering
  (:require [reagent.core :as reagent]
            [simply-ux.state-store :as state-store]
            [simply-ux.component.config :as component-config]))

(defn with-state
  [render state-scope props]
  (fn []
    (let [state (if (not state-scope)
                  (state-store/current-state)
                  (state-store/scoped-current-state
                   state-scope))]
      (if (not (empty? props))
        (render state props)
        (render state)))))


(defn render-without-state-as-param
  [component]
  (if (component-config/config-map?
       component)
    (:render component)
    component))


(defn build-render-function
  [component]
  (if (not (component-config/component-acts-as-a-container?
            component))
    (let [state-scope     (component-config/extract-state-scope component)

          props           (component-config/extract-props component)

          render-function (if (component-config/config-map? component)
                            (:render component)
                            component)]

      (with-state render-function state-scope props))

    ;; State is NOT derefed when acting as a container
    ;; and will not re-render the container when state changes.
    (render-without-state-as-param component)))
