(ns simply-ux.component.initial-state
  (:require [simply-ux.state-store :as state-store]
            [simply-ux.component.config :as component-config]))


(defn build-initial-state-reducer-config
  [component]
  (let [reducers {"INITIAL-STATE"
                  (fn [initial-state state]
                    (merge state
                           initial-state))}]
    (if-let [scope (component-config/extract-state-scope
                    component)]
      {:scope scope :reducers reducers}
      reducers)))


(defn intitial-state-handler
  [existing-component-will-mount
   {:keys [initial-state] :as component}]
  (let [reducers (build-initial-state-reducer-config
                  component)]
    (fn []
      (state-store/dispatch
       :reducers reducers
       :action ["INITIAL-STATE" initial-state])

      (when existing-component-will-mount
        (existing-component-will-mount)))))


(defn include-intial-state
  [component]
  (if-let [initial-state (component-config/extract-initial-state
                          component)]
    (update component :component-will-mount
            (fn [existing-component-will-mount]
              (intitial-state-handler
               existing-component-will-mount
               component)))
    ;; No initial state
    component))
