(ns simply-ux.component.builder
  (:require [reagent.core :as reagent]
            [simply-ux.component.rendering :as component-rendering]
            [simply-ux.component.life-cycle :as component-life-cycle]))

(defn ->component
  [component]
  (let [render-function (component-rendering/build-render-function
                         component)

        life-cyle       (component-life-cycle/build-life-cycle-handlers
                         component)]
    [(with-meta
       render-function
       life-cyle)]))


(defn ->child-component
  "Wraps ->component in a function which allows you to use def to define components"
  [component]
  (fn []
    (->component component)))


(def define-component ->child-component)
